<?php

include('zklib/ZKLib.php');
ini_set('max_execution_time', 300);
ini_set('memory_limit', '512M');

header('Content-Type: application/json'); // Ensure correct response headers

if (isset($_POST['ip']) && isset($_POST['port'])) {
    $attendance = [];
    $ip = $_POST['ip'];
    $port = $_POST['port'] ?? '4370';
    $rows_from = isset($_POST['last_sync']) ? strtotime($_POST['last_sync']) : 0; // Convert to timestamp
    
    try {
        $zk = new ZKLib($ip, $port);
        if ($zk->connect()) {
            $zk->disableDevice();
            $attendance = $zk->getAttendance();
            $zk->enableDevice();
            echo json_encode($attendance);exit;
            // foreach ($attendance as $attItem) {
            //     $attItem = array_map('trim', $attItem);
            //     $recordTime = isset($attItem['timestamp']) ? strtotime($attItem['timestamp']) : 0;
            //     if ($recordTime > $rows_from) {
            //         $rows[] = [
            //             'uid'       => $attItem['uid'] ?? '',
            //             'id'        => $attItem['id'] ?? '',
            //             'state'     => $attItem['state'] ?? '',
            //             'timestamp' => date("Y-m-d H:i:s", $recordTime),
            //         ];
            //     }
            // }

            $zk->enableDevice();

            echo json_encode([
                'status' => 'success',
                'message' => 'Updated attendance data fetched successfully.',
                'data' => $attendance
            ]);
            exit;
        } else {
            echo json_encode($attendance);exit;
            echo json_encode([
                'status' => 'error',
                'message' => 'Unable to connect to the device at ' . $ip . ':' . $port
            ]);
            exit;
        }

    } catch (Exception $e) {
        echo json_encode($attendance);exit;
        echo json_encode([
            'status' => 'error',
            'message' => 'Exception: ' . $e->getMessage()
        ]);
        exit;
    }
}
echo json_encode($attendance);exit;
echo json_encode([
    'status' => 'error',
    'message' => 'Missing required POST parameters: ip and port.'
]);
exit;
