<?php
include('zklib/ZKLib.php');
ini_set('max_execution_time', 300);
ini_set('memory_limit', '512M');

header('Content-Type: application/json'); // Ensure correct response headers

if (isset($_POST['ip']) && isset($_POST['port'])) {
    $rows = [];
    $ip = $_POST['ip'];
    $port = $_POST['port'] ?? '4370';

    try {
        $zk = new ZKLib($ip, $port);

        if ($zk->connect()) {
            $zk->disableDevice();
            sleep(1); // optional delay
            $attendance = $zk->getAttendance();

            foreach ($attendance as $attItem) {
                $attItem = array_map('trim', $attItem);
                $rows[] = [
                    'uid'       => $attItem['uid'] ?? '',
                    'id'        => $attItem['id'] ?? '',
                    'state'     => $attItem['state'] ?? '',
                    'timestamp' => isset($attItem['timestamp']) ? date("Y-m-d H:i:s", strtotime($attItem['timestamp'])) : '',
                ];
            }

            $zk->enableDevice();

            echo json_encode([
                'status' => 'success',
                'message' => 'Attendance data fetched successfully.',
                'data' => $rows
            ]);
            exit;
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Unable to connect to the device at ' . $ip . ':' . $port
            ]);
            exit;
        }

    } catch (Exception $e) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Exception: ' . $e->getMessage()
        ]);
        exit;
    }
}

echo json_encode([
    'status' => 'error',
    'message' => 'Missing required POST parameters: ip and port.'
]);
exit;
