<?php

include('zklib/ZKLib.php');

$servername = 'localhost';
$username = 'erpcreativegarag_mgh';
$password = 'jjV+m=gzdh@w';
$dbname = 'erpcreativegarag_mangla_green_housing';

$mysqli = new mysqli($servername, $username, $password, $dbname);
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Enable exception mode for MySQLi
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

$enableGetDeviceInfo = true;
$enableGetUsers = false;
$enableGetData = true;

if (isset($_POST['system']) && !empty($_POST['system'])) {
    $ip = "";
    $system = $_POST['system'];
    $companyId = '';

    if ($system == "mangla") {
        $ip = "182.191.84.147";
        $companyId = 1;
    } elseif ($system == "lahore") {
        $ip = "119.153.100.112";
        $companyId = 2;
    }

    try {
        $zk = new ZKLib($ip);
        $ret = $zk->connect();

        if ($ret) {
            $mysqli->begin_transaction(); // Start DB transaction

            if ($enableGetData) {
                $attendance = $zk->getAttendance();
                $zk->disableDevice();
                sleep(1); // Optional delay

                if (count($attendance) > 0) {
                    $insertion_count = 0;

                    foreach ($attendance as $attItem) {
                        $uid = $attItem['uid'];
                        $id = $attItem['id'];
                        $state = $attItem['state'];
                        $timestamp = date("Y-m-d H:i:s", strtotime($attItem['timestamp']));
                        $deviceId = $uid;

                        // Check if record already exists
                        $checkStmt = $mysqli->prepare("SELECT COUNT(*) FROM attendance_import WHERE userId = ? AND companyId = ? AND state = ? AND deviceId = ? AND deviceTime = ?");
                        $checkStmt->bind_param("iiiss", $id, $companyId, $state, $deviceId, $timestamp);
                        $checkStmt->execute();
                        $checkStmt->bind_result($count);
                        $checkStmt->fetch();
                        $checkStmt->close();

                        if ($count == 0) {
                            // Insert new attendance record
                            $insertStmt = $mysqli->prepare("INSERT INTO attendance_import (uuid, userId, companyId, state, deviceId, deviceTime) VALUES (?, ?, ?, ?, ?, ?)");
                            $insertStmt->bind_param("iiiiss", $uid, $id, $companyId, $state, $deviceId, $timestamp);
                            $insertStmt->execute();
                            $insertStmt->close();
                            $insertion_count++;
                        }
                    }
                }

                $zk->enableDevice();
                $mysqli->commit(); // Commit transaction

                $message = "$insertion_count Attendance Record(s) Loaded...";
                echo "<script>
                        alert('$message');
                        window.location.href = '../index.php?r=attendance/';
                      </script>";
                exit;
            } else {
                $mysqli->rollback();
                echo "<script>
                        alert('Attendance fetching is disabled.');
                        window.location.href = '../index.php?r=attendance/';
                      </script>";
                exit;
            }
        } else {
            $mysqli->rollback();
            echo "<script>
                    alert('Unable to connect to Device at the moment. Try Later!');
                    window.location.href = '../index.php?r=attendance/';
                  </script>";
            exit;
        }
    } catch (Exception $e) {
        $mysqli->rollback();
        $error = addslashes($e->getMessage());
        echo "<script>
                alert('Error: $error');
                window.location.href = '../index.php?r=attendance/';
              </script>";
        exit;
    }
} else {
    echo "<script>
            alert('Invalid Access!');
            window.location.href = '../index.php?r=attendance/';
          </script>";
    exit;
}
