<?php

include('zklib/ZKLib.php');
ini_set('max_execution_time', 300);
ini_set('memory_limit', '512M');

$rows = [];

if (isset($_GET['system_ip']) && !empty($_GET['system_ip'])) {
    $ip = $_GET['system_ip'];

    try {
        $zk = new ZKLib($ip);
        if ($zk->connect()) {
            $attendance = $zk->getAttendance();
            sleep(1); 
            $zk->disableDevice(); // Disable after fetch

            foreach ($attendance as $attItem) {
                $attItem = array_map('trim', $attItem); // Clean keys
                $rows[] = [
                    'uid'       => $attItem['uid'] ?? '',
                    'id'        => $attItem['id'] ?? '',
                    'state'     => $attItem['state'] ?? '',
                    'timestamp' => isset($attItem['timestamp']) ? date("Y-m-d H:i:s", strtotime($attItem['timestamp'])) : '',
                ];
            }

            $zk->enableDevice();

            echo json_encode($rows, JSON_PARTIAL_OUTPUT_ON_ERROR); exit;
        }
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]); exit;
    }
}

echo json_encode($rows); exit;
